<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
use \Illuminate\Support\Facades\Artisan;
//'%:'.$cc.'::%'
//Route::get('updatePath',function(){
//    $model=\App\Models\User::find(33);
//    dd(updateModelPath($model));
//});
Route::get('/clear-cache', function () {
    $exitCode=Artisan::call('cache:clear');
    return '<h1>Cache facade value cleared</h1>';
});

//Reoptimized class loader:
Route::get('/optimize', function () {
    $exitCode=Artisan::call('optimize');
    return '<h1>Reoptimized class loader</h1>';
});

Route::get('/optimize-clear', function () {
    $exitCode=Artisan::call('optimize:clear');
    return '<h1>Reoptimized class loader</h1>';
});

//Route cache:
Route::get('/route-cache', function () {
    $exitCode=Artisan::call('route:cache');
    return '<h1>Routes cached</h1>';
});

//Clear Route cache:
Route::get('/route-clear', function () {
    $exitCode=Artisan::call('route:clear');
    return '<h1>Route cache cleared</h1>';
});

//Clear View cache:
Route::get('/view-clear', function () {
    $exitCode=Artisan::call('view:clear');
    return '<h1>View cache cleared</h1>';
});

//Clear Config cache:
Route::get('/config-cache', function () {
    $exitCode=Artisan::call('config:cache');
    return '<h1>Clear Config cleared</h1>';
});

//Clear Config cache:
Route::get('/config-clear', function () {
    $exitCode=Artisan::call('config:clear');
    return '<h1>Clear Config cleared</h1>';
});
Route::get('/', function () {
    return redirect()->route('login');
    return view('welcome');
});

Auth::routes();
Route::get('/dashboard', [App\Http\Controllers\Dashboard\DashboardController::class, 'index'])->name('dashboard');
Route::group(['middleware'=>['auth','UserRoles'],'prefix'=>'dashboard'],function(){
    /*start roles routes*/
    Route::group(['prefix'=>'roles'],function(){
        Route::resource('/',\App\Http\Controllers\Dashboard\RolesController::class)->names([
            'index'=>'roles.index',
            'create'=>'roles.create',
            'store'=>'roles.store',
            'update'=>'roles.update',
            'edit'=>'roles.edit',
            'destroy'=>'roles.destroy',
            'show'=>'roles.show',
        ])->parameter('','role');
    });
    /*end roles routes*/
    /*start users routes*/
    Route::group(['prefix'=>'users'],function(){
        Route::get('/profile',[\App\Http\Controllers\Dashboard\UsersController::class,'profile'])->name('users.profile');
        Route::put('/profile',[\App\Http\Controllers\Dashboard\UsersController::class,'profileUpdate'])->name('users.profile_update');
        Route::delete('/delete-multi',[\App\Http\Controllers\Dashboard\UsersController::class,'deleteMulti'])->name('users.multi_destroy');
        Route::post('/export',[\App\Http\Controllers\Dashboard\UsersController::class,'export'])->name('users.export');
        Route::resource('/',\App\Http\Controllers\Dashboard\UsersController::class)->names([
            'index'=>'users.index',
            'create'=>'users.create',
            'store'=>'users.store',
            'update'=>'users.update',
            'edit'=>'users.edit',
            'destroy'=>'users.destroy',
            'show'=>'users.show',
        ])->parameter('','user');

    });
    /*end users routes*/

    /*start departments routes*/
    Route::group(['prefix'=>'departments'],function(){
        Route::delete('/delete-multi',[\App\Http\Controllers\Dashboard\DepartmentsController::class,'deleteMulti'])->name('departments.multi_destroy');
        Route::post('/export',[\App\Http\Controllers\Dashboard\DepartmentsController::class,'export'])->name('departments.export');
        Route::resource('/',\App\Http\Controllers\Dashboard\DepartmentsController::class)->names([
            'index'=>'departments.index',
            'create'=>'departments.create',
            'store'=>'departments.store',
            'update'=>'departments.update',
            'edit'=>'departments.edit',
            'destroy'=>'departments.destroy',
            'show'=>'departments.show',
        ])->parameter('','department');

    });
    /*end departments routes*/

    /*start job_titles routes*/
    Route::group(['prefix'=>'job_titles'],function(){
        Route::delete('/delete-multi',[\App\Http\Controllers\Dashboard\JobTitlesController::class,'deleteMulti'])->name('job_titles.multi_destroy');
        Route::post('/export',[\App\Http\Controllers\Dashboard\JobTitlesController::class,'export'])->name('job_titles.export');
        Route::resource('/',\App\Http\Controllers\Dashboard\JobTitlesController::class)->names([
            'index'=>'job_titles.index',
            'create'=>'job_titles.create',
            'store'=>'job_titles.store',
            'update'=>'job_titles.update',
            'edit'=>'job_titles.edit',
            'destroy'=>'job_titles.destroy',
            'show'=>'job_titles.show',
        ])->parameter('','job_title');

    });
    /*end job_titles routes*/

    /*start kpis routes*/
    Route::group(['prefix'=>'kpis'],function(){
        Route::delete('/delete-multi',[\App\Http\Controllers\Dashboard\KPISController::class,'deleteMulti'])->name('kpis.multi_destroy');
        Route::post('/export',[\App\Http\Controllers\Dashboard\KPISController::class,'export'])->name('kpis.export');
        Route::resource('/',\App\Http\Controllers\Dashboard\KPISController::class)->names([
            'index'=>'kpis.index',
            'create'=>'kpis.create',
            'store'=>'kpis.store',
            'update'=>'kpis.update',
            'edit'=>'kpis.edit',
            'destroy'=>'kpis.destroy',
            'show'=>'kpis.show',
        ])->parameter('','kpi');

    });
    /*end kpis routes*/


    /*start users_kpis routes*/
    Route::get('/users_kpis_report',[\App\Http\Controllers\Dashboard\UsersKPISController::class,'report'])->name('users_kpis.report');
    Route::get('/users_kpis_total_report',[\App\Http\Controllers\Dashboard\UsersKPISController::class,'totalReport'])->name('users_kpis.total_report');
    Route::group(['prefix'=>'users_kpis'],function(){

        Route::delete('/delete-multi',[\App\Http\Controllers\Dashboard\UsersKPISController::class,'deleteMulti'])->name('users_kpis.multi_destroy');
        Route::post('/export',[\App\Http\Controllers\Dashboard\UsersKPISController::class,'export'])->name('users_kpis.export');
        Route::resource('/',\App\Http\Controllers\Dashboard\UsersKPISController::class)->names([
            'index'=>'users_kpis.index',
            'create'=>'users_kpis.create',
            'store'=>'users_kpis.store',
            'update'=>'users_kpis.update',
            'edit'=>'users_kpis.edit',
            'destroy'=>'users_kpis.destroy',
            'show'=>'users_kpis.show',
        ])->parameter('','users_kpi');

    });
    /*end users_kpis routes*/
});

