@extends('dashboard.layouts.app')
@push('headScripts')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css" integrity="sha512-mSYUmp1HYZDFaVKK//63EcZq4iFWFjxSL+Z3T/aCt4IO9Cejm03q3NKKYN6pFQzY0SBOr8h+eCIAZHPXcpZaNw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="{{ asset('assets/plugins/bootstrap-datepicker/css/bootstrap-datepicker.css') }}"  />
@endpush
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">{{ __('KPIS') }} /</span> <a href="{{ route('users_kpis.index') }}" class="text-muted fw-light">{{ __('Users KPIS') }} /</a> {{ (isset($users_kpi))?__('Edit :type',['type'=>$users_kpi->name]):__('Create') }}</h4>
        <div class="row">
            <div class="col-md-12">
                <form method="POST" action="{{ isset($users_kpi)?route('users_kpis.update',['users_kpi'=>$users_kpi]):route('users_kpis.store') }}" enctype="multipart/form-data">
                    @if(isset($users_kpi))
                        @method('PUT')
                    @endif
                    @csrf
                    <div class="card mb-4">
                        <h5 class="card-header">{{ (isset($users_kpi))?__('Edit :type',['type'=>$users_kpi->name]):__('Create') }}</h5>
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-lg-12 mb-3">
                                    <label class="form-label">{{ __('Year & Month') }}</label>
                                    <input @if(isset($users_kpi)) disabled="disabled" @endif type="text" class="form-control @error('month') is-invalid @enderror @error('year') is-invalid @enderror" id="year_month" name="year_month" value="{{ isset($users_kpi)?$users_kpi->month.'-'.$users_kpi->year:old('year_month') }}"/>
                                    @error('year')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                    @error('month')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-12 mb-3 @if(!old('user_id')&&!isset($users_kpi)){{ 'd-none' }}@endif">
                                    <label class="form-label">{{ __('Responsible Employee') }}</label>
                                    <select @if(isset($users_kpi)) disabled="disabled" @endif class="select2 @error('user_id') is-invalid @enderror" data-placeholder="{{ __('Select :type',['type'=>__('Responsible Employee')]) }}" id="user_id" name="user_id">
                                        <option value="">{{ __('Select :type',['type'=>__('Responsible Employee')]) }}</option>
                                        @if(PerUser('users_kpis.show_all'))
                                            @php($usersData=\App\Models\User::whereIn('job_title_id',\App\Models\KPI::where('status','published')->has('KPISQuestions')->pluck('job_title_id')->toArray())->pluck('name','id')->toArray() )
                                        @else
                                            @php($usersData=\App\Models\User::whereIn('job_title_id',\App\Models\KPI::where('status','published')->has('KPISQuestions')->pluck('job_title_id')->toArray())->where(function ($q){$q->where('path','LIKE','%:'.auth()->id().'::%')->where('id','!=',auth()->id());})->pluck('name','id')->toArray() )
                                        @endif
                                        @foreach($usersData as $id=>$name)
                                            <option @if((isset($users_kpi)&&$users_kpi->user_id==$id)||old('user_id')==$id) selected="selected" @endif value="{{ $id }}">{{ $name }}</option>
                                        @endforeach
                                    </select>
                                    @error('user_id')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                            </div>
                        </div>



                    </div>
                        <div class="@if(!old('questionsIDS')&&!isset($users_kpi)){{ 'd-none' }}@endif" id="questionsData">
                            @if(isset($users_kpi))
                                @include('dashboard.users_kpis.show_questions',['userKPIQuestions'=>$users_kpi->Questions])
                            @elseif(old('questionsIDS'))
                                @include('dashboard.users_kpis.show_questions',['questions'=>\App\Models\KPISQuestion::whereIn('id',old('questionsIDS'))->get()])
                            @endif
                        </div>
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="text-center">
                                <button type="submit" id="submitData" disabled class="btn btn-danger px-5">{{ __('Save') }}</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@push('footerScripts')

    <script src="{{ asset('assets/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js') }}" ></script>
    <script type="text/javascript">
        function checkAndEnableButton(){
            let isTrue=true;
            @if(!isset($users_kpi))
            if(!$("#year_month").val()){
                isTrue=false;
            }
            if(!$("#user_id").val()){
                isTrue=false;
            }
            @endif
            $(".question-item").each(function(){
                let parentElement=$(this);
                let targetElement=parentElement.find('.target');
                let actualElement=parentElement.find('.actual');
                let scoreElement=parentElement.find('.score');
                let target=parseInt(targetElement.val());
                let actual=parseInt(actualElement.val());
                console.log(target,actual)
                if(isNaN(actual)||isNaN(target)||actual>target){
                    isTrue=false;
                    return false;
                }
            });
            console.log(isTrue)
            if(isTrue){
                $("#submitData").removeAttr('disabled');
            }else{
                $("#submitData").attr('disabled','disabled');
            }
        }
        checkAndEnableButton();
        function calculateProgress(parentElement){
            console.log(parentElement);
            let targetElement=parentElement.find('.target');
            let actualElement=parentElement.find('.actual');
            let scoreElement=parentElement.find('.score');
            let target=parseInt(targetElement.val());
            let actual=parseInt(actualElement.val());
            if(actual>target){
                scoreElement.addClass('bg-danger')
            }else{
                scoreElement.removeClass('bg-danger')
            }
            let percentage=(actual/target)*100
            percentage=isNaN(percentage)?0:percentage;
            scoreElement.css({width:percentage+'%'}).attr('aria-valuenow',percentage).text(percentage+'%')
        }
        @if(old('questionsIDS'))
        $(".question-item").each(function(){
            calculateProgress($(this))
        })
        checkAndEnableButton()
        @endif
        $("#year_month").datepicker( {
            format: "mm-yyyy",
            viewMode: "months",
            minViewMode: "months"
        });
        $(document).on('change','#year_month',function(){
            console.log('change')
            $(this).parent().next().removeClass('d-none')
            getQuestions();
            checkAndEnableButton();
        });
        function getQuestions(){
            let userSelectElement=$("#user_id")
            let yearMonthElement=$("#year_month")
            let user_id = userSelectElement.val();
            let year_month = yearMonthElement.val();
            if(user_id&&year_month){
                userSelectElement.attr('disabled','disabled').parent().find('.select2.select2-container').addClass('loading');
                yearMonthElement.attr('disabled','disabled').addClass('loading-input');
                $.ajax({
                    type: "GET",
                    url: "{{ request()->fullUrl() }}",
                    data: {user_id, year_month},
                    success: function (msg) {
                        userSelectElement.removeAttr('disabled').parent().find('.select2.select2-container').removeClass('loading');
                        yearMonthElement.removeAttr('disabled').removeClass('loading-input');
                        if (msg.success) {
                            $("#questionsData").removeClass('d-none').html(msg.html);
                        } else {
                            $.notify(msg.message ? msg.message : 'Ops Please try again ', {
                                blur: 0.2,
                                delay: 0,
                                close: true,
                                color: "#fff",
                                background: "#D44950",
                                animationType: "drop"
                            });
                            $("#questionsData").addClass('d-none').html('')
                        }

                    }
                });
            }

        }
        $(document).on('change','#user_id',function() {
            getQuestions();
        });
        $(document).on('change keyup','.target,.actual',function(){
            if($(this).hasClass('target')){
                if($(this).val()<1&&$(this).val()!=''){
                    $(this).val(1);
                }
            }else{
                if($(this).val()<0&&$(this).val()!=''){
                    $(this).val(0);
                }
            }

            let parentElement=$(this).parent().parent();
            calculateProgress(parentElement);
            checkAndEnableButton()
        });
    </script>
    <style>
        #ui-datepicker-div{
            z-index: 99;
        }
        .ui-datepicker-calendar {
            display: none;
        }
    </style>
@endpush
