@extends('dashboard.layouts.app')
@push('headScripts')
    <style>
        #submitButton.disabledSubmit{
            cursor: no-drop;
            opacity: 0.65;
        }
    </style>
@endpush
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">{{ __('KPIS') }} /</span> <a href="{{ route('kpis.index') }}" class="text-muted fw-light">{{ __('KPIS') }} /</a> {{ (isset($kpi))?__('Edit :type',['type'=>$kpi->name]):__('Create') }}</h4>
        <div class="row">
            <div class="col-md-12">
                <form method="POST" action="{{ isset($kpi)?route('kpis.update',['kpi'=>$kpi]):route('kpis.store') }}" enctype="multipart/form-data">
                    <div class="card mb-4">
                        <h5 class="card-header">{{ (isset($kpi))?__('Edit :type',['type'=>$kpi->name]):__('Create') }}</h5>
                        @if(isset($kpi))
                            @method('PUT')
                        @endif
                        @csrf
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-lg-12 mb-3">
                                    <label class="form-label">{{ __('Job Titles') }}</label>
                                    <select class="select2 @error('job_title_id') is-invalid @enderror" data-placeholder="{{ __('Select :type',['type'=>__('Job Title')]) }}" name="job_title_id">
                                        <option value="">{{ __('Select :type',['type'=>__('Job Title')]) }}</option>
                                        @foreach(\App\Models\JobTitle::pluck('title','id')->toArray() as $id=>$name)
                                            <option @if((isset($kpi)&&$kpi->job_title_id==$id)||old('job_title_id')==$id) selected="selected" @endif value="{{ $id }}">{{ $name }}</option>
                                        @endforeach
                                    </select>
                                    @error('job_title_id')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-12 mb-3">
                                    <label class="form-label">{{ __('Name') }}</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror border-left-0" name="name" id="name" value="{{ isset($kpi)?$kpi->name:old('name') }}" placeholder="{{ __('Enter :value',['value'=>__('Name')]) }}">
                                    @error('name')
                                    <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                    @enderror
                                </div>
                                <div class="btn-group" role="group" aria-label="Basic radio toggle button group">
                                    @foreach(config('app.statusArray') as $key=>$status)
                                        <input type="radio" class="btn-check" name="status" id="status-{{ $key+1 }}" {{ (isset($kpi)&&$kpi->status==$status)||(old('status')&&old('status')==$status)||(!isset($kpi)&&!old('status')&&$status==config('app.defaultStatusSelected'))?'checked':'' }} value="{{ $status }}"  autocomplete="off">
                                        <label class="btn btn-outline-{{ config('app.statusButtonClass')[$status] }}" for="status-{{ $key+1 }}">{{ ucfirst($status) }}</label>
                                    @endforeach
                                </div>
                                @error('status')
                                <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="card mb-4 fixme">
                        <div class="d-flex bd-highlight">
                            <div class="p-2 flex-fill bd-highlight">
                                <h5 class="card-header">{{ __('Create Questions') }}</h5>
                            </div>
                            <div class="p-2 flex-fill align-self-center bd-highlight">
                                <button type="button" class="btn btn-success float-end addQuestion" data-type="end">
                                    <i class="bx bx-plus-circle"></i>
                                </button>
                            </div>

                        </div>
                        <div class="progress w-100">
                            <div class="progress-bar" role="progressbar" style="width:  0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
                               0%
                            </div>
                        </div>
                    </div>
                    <div id="questionsDiv">
                        {{--                    <div class="card mb-4">--}}
                        {{--                        <div class="card-body">--}}
                        {{--                            <div class="form-group col-lg-12 mb-3">--}}
                        {{--                                <label class="form-label">{{ __('Question') }}</label>--}}
                        {{--                                <input type="text" class="form-control @error('question') is-invalid @enderror border-left-0" name="question[]" id="question" placeholder="{{ __('Enter :value',['value'=>__('Question')]) }}">--}}
                        {{--                            </div>--}}
                        {{--                            <div class="form-group col-lg-12 mb-3">--}}
                        {{--                                <label class="form-label">{{ __('Weight') }}</label>--}}
                        {{--                                <input type="number" class="form-control @error('weight') is-invalid @enderror border-left-0" name="weight[]" id="weight" placeholder="{{ __('Enter :value',['value'=>__('Weight')]) }}">--}}
                        {{--                            </div>--}}
                        {{--                            <div class="d-grid gap-2">--}}
                        {{--                                <button class="btn btn-danger remove-question">--}}
                        {{--                                    <i class="bx bx-trash"></i>--}}
                        {{--                                    {{ __('Delete') }}--}}
                        {{--                                </button>--}}
                        {{--                            </div>--}}
                        {{--                        </div>--}}
                        {{--                    </div>--}}
                        @if(isset($kpi)&&$kpi->KPISQuestions)
                            @foreach($kpi->KPISQuestions as $question)
                                <div class="card mb-4">
                                    <div class="card-body">
                                        <input type="hidden" name="question_id[]" value="{{ $question->id }}"/>
                                        <div class="form-group col-lg-12 mb-3">
                                            <label class="form-label">{{ __('Question') }}</label>
                                            <input type="text" class="form-control @error('question') is-invalid @enderror border-left-0" name="question[]" value="{{ $question->question }}" id="question" placeholder="{{ __('Enter :value',['value'=>__('Question')]) }}">
                                        </div>
                                        <div class="form-group col-lg-12 mb-3">
                                            <label class="form-label">{{ __('Weight') }}</label>
                                            <input type="number" min="1" step="1" class="form-control @error('weight') is-invalid @enderror border-left-0" name="weight[]" value="{{ $question->weight }}" id="weight" placeholder="{{ __('Enter :value',['value'=>__('Weight')]) }}">
                                        </div>
                                        <div class="text-end">
                                            <button type="button" class="btn btn-danger remove-question">
                                                <i class="bx bx-trash"></i>
                                                {{ __('Delete') }}
                                            </button>
                                            <button type="button" class="btn btn-success addQuestion" data-type="after">
                                                <i class="bx bx-arrow-to-bottom"></i>
                                                {{ __('Add After') }}
                                            </button>
                                            <button type="button" class="btn btn-success addQuestion" data-type="before">
                                                <i class="bx bx-arrow-to-top"></i>
                                                {{ __('Add Before') }}
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="text-end">
                                <button type="button" id="submitButton" data-bs-toggle="tooltip"
                                        data-bs-offset="0,4"
                                        data-bs-placement="left"
                                        data-bs-html="false"
                                        title="Save"
                                        class="btn btn-success px-5">{{ __('Save') }}</button>
                            </div>

                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@push('footerScripts')
    <script>
        let htmlQuestionBlock='<div class="card mb-4"> <input type="hidden" name="question_id[]" value="no_id"/> <div class="card-body"> <div class="form-group col-lg-12 mb-3"> <label class="form-label">{{ __('Question') }}</label> <input type="text" class="form-control @error('question') is-invalid @enderror border-left-0" name="question[]" id="question" placeholder="{{ __('Enter :value',['value'=>__('Question')]) }}"> </div> <div class="form-group col-lg-12 mb-3"> <label class="form-label">{{ __('Weight') }}</label> <input type="number" min="1" step="1" class="form-control @error('weight') is-invalid @enderror border-left-0" name="weight[]" id="weight" placeholder="{{ __('Enter :value',['value'=>__('Weight')]) }}"> </div> <div class="text-end"> <button type="button" class="btn btn-danger remove-question"> <i class="bx bx-trash"></i>{{ __('Delete') }} </button><button type="button" class="btn btn-success addQuestion" data-type="after"><i class="bx bx-arrow-to-bottom"></i>{{ __('Add After') }}</button><button type="button" class="btn btn-success addQuestion" data-type="before"><i class="bx bx-arrow-to-top"></i>{{ __('Add Before') }}</button> </div> </div> </div>';
        $(document).on('click','.addQuestion',function(){
            let type=$(this).attr('data-type');
            let element=$(this).parent().parent().parent()
            let questionsDiv=$("#questionsDiv");
            switch (type){
                case'end':
                    questionsDiv.append(htmlQuestionBlock);
                    animateCSS('#questionsDiv > div.card.mb-4:nth-of-type('+($("#questionsDiv div.card.mb-4").length)+')','bounce')
                    break;
                case'after':
                    $(htmlQuestionBlock).insertAfter(element);
                    animateCSS('#questionsDiv > div.card.mb-4:nth-of-type('+(element.index()+2)+')','bounce')
                    break;
                case'before':
                    console.log(element.index())
                    let eq=(element.index()==0?1:(element.index()-1));
                    console.log(eq)
                    $(htmlQuestionBlock).insertBefore(element);
                    animateCSS('#questionsDiv > div.card.mb-4:nth-of-type('+eq+')','bounce')
                    break;
            }
        });

        $(document).on('click','.remove-question',function(){
            $(this).parent().parent().parent().remove();
            getPercentage();
        });
        $(document).on('change keyup','input[name="weight[]"]',function(){
            if($(this).val()<1&&$(this).val()!=''){
                $(this).val(1);
            }
            getPercentage()
        })
        function getPercentage(){
            let percentage=0;
            $('input[name="weight[]"]').each(function(){
                percentage+=parseInt($(this).val());
            })
            if(percentage!=100){
                $(".fixme .progress .progress-bar").addClass('bg-danger');
                $('#submitButton').addClass('disabledSubmit').attr('data-bs-original-title','{{ __('Make sure that all questions total wights is 100%') }}').attr('type','button')
            }else{
                $(".fixme .progress .progress-bar").removeClass('bg-danger');
                $('#submitButton').removeClass('disabledSubmit').attr('data-bs-original-title','Save').attr('type','submit');
            }
            $(".fixme .progress .progress-bar").attr('aria-valuenow',percentage).css({'width':percentage+'%'}).text(percentage+'%')
        }
        getPercentage();
        var fixmeTop = $('.fixme').offset().top;       // get initial position of the element
        var fixmeWidth = $('.fixme').width();       // get initial position of the element
        $(window).scroll(function() {                  // assign scroll event listener
            var currentScroll = $(window).scrollTop(); // get current position
            if (currentScroll >= fixmeTop) {           // apply position: fixed if you
                $('.fixme').css({                      // scroll to that element or below it
                    top: 0,
                    position: 'fixed',
                    width:fixmeWidth,
                    'z-index':9
                });
            } else {                                   // apply position: static
                $('.fixme').css({                      // if you scroll above it
                    position: 'static'
                });
            }

        });
    </script>
@endpush
