<?php

namespace App\Exports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class UsersExport implements WithMapping, WithHeadings,FromQuery
{

    public function query()
    {
        $users=User::query();
        if(request('IDS')){
            $users=$users->whereIn('id',explode(',',request('IDS')));
        }
        return $users;
    }
    /**
    * @return \Illuminate\Support\Collection
    */

    public function map($user) : array {
        return [

            $user->Parent?$user->Parent->name:__('No Responsible Employee'),
            $user->Department?$user->Department->title:__('No Department'),
            $user->JobTitle?$user->JobTitle->title:__('No Job Title'),
            $user->name,
            $user->email,
            $user->mobile,
            $user->birth_date,
            $user->roles->map(function($role) {
                return __(ucwords($role->name));
            })->implode(','),
            $user->permissions->map(function($permission) {
                return __(ucwords($permission->name));
            })->implode(','),
            $user->last_login_at?$user->last_login_at->diffForHumans():'',
            $user->created_at?$user->created_at->format('d M Y, h:i a'):'',

        ] ;
    }
    public function headings() : array {
        return [
            __('Parent'),
            __('Department'),
            __('Job Title'),
            __('Name'),
            __('Email'),
            __('Mobile'),
            __('Birth Date'),
            __('Roles'),
            __('Permissions'),
            __('Last Login'),
            __('Created At')
        ] ;
    }
}
