<?php

namespace App\Exports;

use App\Models\JobTitle;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class JobTitlesExport implements WithMapping, WithHeadings,FromQuery
{

    public function query()
    {
        $job_titles=JobTitle::query();
        if(request('IDS')){
            $job_titles=$job_titles->whereIn('id',explode(',',request('IDS')));
        }
        return $job_titles;
    }
    /**
    * @return \Illuminate\Support\Collection
    */

    public function map($job_title) : array {
        return [

            $job_title->title,
            $job_title->status,
            $job_title->created_at?$job_title->created_at->format('d M Y, h:i a'):'',

        ] ;
    }
    public function headings() : array {
        return [
            __('Title'),
            __('Status'),
            __('Created At')
        ] ;
    }
}
