<html
    lang="en"
    class="light-style layout-menu-fixed"
    dir="ltr"
    data-theme="theme-default"
    data-assets-path="{{ asset('assets') }}/"
    data-template="vertical-menu-template-free"
>
<head>
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta charset="utf-8" />
    <meta
        name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"
    />

    <title>{{ config('app.name', 'Laravel') }}</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('assets') }}/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet"
    />

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="{{ asset('assets') }}/vendor/fonts/boxicons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="{{ asset('assets/vendor/css/core.css') }}" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{ asset('assets/vendor/css/theme-default.css') }}" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="{{ asset('assets/css/demo.css') }}" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />

    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/apex-charts/apex-charts.css') }}" />
    <link rel="stylesheet" type="text/css" href="{{ config('sweetalert.animatecss') }}">
    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="{{ asset('assets/vendor/js/helpers.js') }}"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="{{ asset('assets') }}/js/config.js"></script>

    <link rel="stylesheet" href="{{ asset('assets/plugins/select2/css/select2.min.css') }}"  />
    <link rel="stylesheet" href="{{ asset('assets/plugins/select2/css/select2-bootstrap5.css') }}"  />
    <link rel="stylesheet" type="text/css" href="{{ asset('css/notify.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('css/prettify.css') }}">
    <style>
        .loading {
            position: relative;
        }
        .loading::after {
            position: absolute;
            background: center 1.7857142857rem no-repeat rgba(255, 255, 255, .5);
            background-image: url(https://cf2.s3.souqcdn.com/public/style/img/loading.gif);
            background-repeat: no-repeat;
            background-position: center center;
            background-color: rgba(250, 250, 250, .8);
            background-size: 1.7857142857rem auto;
        }
        .loading::after {
            display: block!important;
            width: 100%;
            height: 100%;
            left: 0;
            top: 0;
            z-index: 148;
            content: ' '!important;
            line-height: 0;
        }
            input.loading-input{
                position: relative;
                background: center 1.7857142857rem no-repeat rgba(255, 255, 255, .5);
                background-image: url(https://cf2.s3.souqcdn.com/public/style/img/loading.gif);
                background-repeat: no-repeat;
                background-position: center center;
                background-color: rgba(250, 250, 250, .8)!important;
                background-size: 1.7857142857rem auto;
            }
        .search-bar-result{
            width: 100%;
            position: absolute;
            right: 0;
            top: 60px;
            background: white;
            border-bottom-right-radius: 20px;
            border-bottom-left-radius: 20px;
            box-shadow: 0 2px 6px 0 rgb(67 89 113 / 12%);
            padding-top: 15px;
            padding-bottom: 15px;
            max-height: 200px;
            overflow-y: auto;
        }
        li.parent-item{
            list-style: none;
            border-bottom: 1px solid #dee2e6!important;
            padding: 10px;
            margin-right: 30px;
        }
        li.parent-item ol{
            list-style: none;
        }
    </style>
    @stack('headScripts')
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->
        @include('dashboard.include.menu')
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
            <!-- Navbar -->

           @include('dashboard.include.navbar')

            <!-- / Navbar -->

            <!-- Content wrapper -->
            <div class="content-wrapper">
                @yield('content')
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
</div>
<!-- / Layout wrapper -->

<!-- Core JS -->
<!-- build:js assets/vendor/js/core.js -->
<script src="{{ asset('assets') }}/vendor/libs/jquery/jquery.js"></script>
<script src="{{ asset('assets') }}/vendor/libs/popper/popper.js"></script>
<script src="{{ asset('assets') }}/vendor/js/bootstrap.js"></script>
<script src="{{ asset('assets') }}/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>

<script src="{{ asset('assets') }}/vendor/js/menu.js"></script>
<!-- endbuild -->

<!-- Vendors JS -->
<script src="{{ asset('assets') }}/vendor/libs/apex-charts/apexcharts.js"></script>

<!-- Main JS -->
<script src="{{ asset('assets') }}/js/main.js"></script>

<!-- Page JS -->
<script src="{{ asset('assets') }}/js/dashboards-analytics.js"></script>
<!-- Page JS -->
<script src="{{ asset('assets') }}/js/ui-popover.js"></script>
<!-- Place this tag in your head or just before your close body tag. -->
<script async defer src="https://buttons.github.io/buttons.js"></script>

<script src="{{ asset('assets/plugins/select2/js/select2.full.min.js') }}"></script>
<script src="{{ asset('js/notify.js?v=1') }}"></script>
<script src="{{ asset('js/prettify.js?v=1') }}"></script>
{{--<!-- Development -->--}}
<script src="https://unpkg.com/@popperjs/core@2/dist/umd/popper.min.js"></script>
<script src="https://unpkg.com/tippy.js@6/dist/tippy-bundle.umd.js"></script>
{{--<!-- Production -->--}}
{{--<script src="https://unpkg.com/@popperjs/core@2"></script>--}}
{{--<script src="https://unpkg.com/tippy.js@6"></script>--}}
<script>
    // Restricts input for the set of matched elements to the given inputFilter function.
    (function($) {
        $.fn.inputFilter = function(callback, errMsg) {
            return this.on("input keydown keyup mousedown mouseup select contextmenu drop focusout", function(e) {
                if (callback(this.value)) {
                    // Accepted value
                    if (["keydown","mousedown","focusout"].indexOf(e.type) >= 0){
                        $(this).removeClass("input-error");
                        this.setCustomValidity("");
                    }
                    this.oldValue = this.value;
                    this.oldSelectionStart = this.selectionStart;
                    this.oldSelectionEnd = this.selectionEnd;
                } else if (this.hasOwnProperty("oldValue")) {
                    // Rejected value - restore the previous one
                    $(this).addClass("input-error");
                    this.setCustomValidity(errMsg);
                    this.reportValidity();
                    this.value = this.oldValue;
                    this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
                } else {
                    // Rejected value - nothing to restore
                    this.value = "";
                }
            });
        };
    }(jQuery));
    $(".number-only").inputFilter(function(value) {
        return /^\d*$/.test(value);    // Allow digits only, using a RegExp
    },"Only digits allowed");
    $('.select2').each(function(){
        $(this).select2({
            theme: 'bootstrap-5',
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            allowClear: Boolean($(this).data('allow-clear')),
        });
    })
    $.ajaxSetup({
        headers : {
            'X-CSRF-Token' : '{{ csrf_token() }}'
        }
    });
    const animateCSS = (element, animation, prefix = 'animate__') =>
        // We create a Promise and return it
        new Promise((resolve, reject) => {
            const animationName = `${prefix}${animation}`;
            const node = document.querySelector(element);
            node.classList.add(`${prefix}animated`, animationName);
            // When the animation ends, we clean the classes and resolve the Promise
            function handleAnimationEnd(event) {
                event.stopPropagation();
                node.classList.remove(`${prefix}animated`, animationName);
                resolve('Animation ended');
            }
            node.addEventListener('animationend', handleAnimationEnd, {once: true});
        });
    var xhr;
    $(window).click(function() {
        //Hide the menus if visible
        $(".search-bar-result").html('').addClass('d-none');
    });

    $('.search-bar-result').click(function(event){
        event.stopPropagation();
    });
    $(document).on('keyup','#search',function(){
        let search=$(this).val();
        if(!search){
            $(".search-bar-result").html('').addClass('d-none');
            return false;
        }
        if(xhr){
            xhr.abort();
        }
        xhr=$.ajax({
            type: "GET",
            url: "{{ route('dashboard') }}",
            data:{search},
            success: function (msg) {
                $(".search-bar-result").html(msg.html).removeClass('d-none');
            }
        });
    });
    $(document).on('keypress keyup','input[type="password"],#old_password,#password',function(e){
        console.log(e.which)
        if(e.which === 32)
            return false;
    })
    $(document).on( 'init.dt', function ( e, settings ) {
       console.log(e)
       console.log(settings)
       console.log('eee')
        let tableElement=$(".dataTables_wrapper.dt-bootstrap4").parent();
        console.log(tableElement.length);
        let tableElTotalWidth=tableElement.get(0).scrollWidth;
        let tableElShowWidth=tableElement.width();
        let totalScroll=tableElTotalWidth-tableElShowWidth;
        if(tableElement.length&&tableElement.get(0).scrollWidth>tableElement.width()+20){
            console.log('eeee');
            console.log(tableElement.get(0).scrollWidth);
            console.log(tableElement.width());
            tableElement.append('<img id="left-arrow" src="{{ asset('images/left-arrow.gif') }}" style="width:50px;position: absolute;right: 0;z-index:99;top: '+(tableElement.position().top+40)+'px;">')
            tableElement.append('<img id="right-arrow" class="d-none" src="{{ asset('images/left-arrow.gif') }}" style="width:50px;position: absolute;left: 0;transform: rotate(180deg);z-index:99;top: '+(tableElement.position().top+40)+'px;">')

        }
        $(tableElement).on('scroll',function(x){
           if(totalScroll==tableElement.scrollLeft()){
               $("#left-arrow").addClass('d-none')
               $("#right-arrow").removeClass('d-none')
           }else{
               $("#left-arrow").removeClass('d-none')
               $("#right-arrow").removeClass('d-none')
           }
           if(tableElement.scrollLeft()==0){
               $("#right-arrow").addClass('d-none')
           }
        })
    } );

</script>
@include('sweetalert::alert')
@stack('footerScripts')
</body>
</html>
