@if(isset($questions))
    @foreach($questions as $question)
        <div class="card mb-4 question-item">
            <div class="card-body">
                <div class="row">
                    <div class="form-group col-12 mb-3">
                        <span class="badge bg-black fw-bold d-block text-start"  style="white-space: break-spaces;line-height: 25px;">{{ $question->question }}</span>
                    </div>
                    <input type="hidden" name="questionsIDS[]" value="{{ $question->id }}">
                    <div class="form-group col-4 mb-3">
                        <label for="question_{{ $question->id }}_target">{{ __('Target') }}</label>
                        <input type="number" class="form-control target" name="question[{{ $question->id }}][target]" id="question_{{ $question->id }}_target" value="{{ old('question.'.$question->id.'.target') }}"/>
                    </div>
                    <div class="form-group col-4 mb-3">
                        <label for="question_{{ $question->id }}_actual">{{ __('Actual') }}</label>
                        <input type="number" class="form-control actual"  name="question[{{ $question->id }}][actual]" id="question_{{ $question->id }}_actual" value="{{ old('question.'.$question->id.'.actual') }}"/>
                    </div>
                    <div class="form-group col-4 mb-3">
                        <label for="question_{{ $question->id }}_score">{{ __('Score') }}</label>
                        {{--                    <input type="text" disabled class="form-control score"  name="question[{{ $question->id }}][score][]" id="question_{{ $question->id }}_score"/>--}}
                        <div class="progress " style="height: 40px;">
                            <div class="progress-bar score" role="progressbar" style="width: 0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
                                0%
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    @endforeach
@endif

@if(isset($userKPIQuestions))
    @foreach($userKPIQuestions as $question)
        <div class="card mb-4 question-item">
            <div class="card-body">
                <div class="row">
                    <div class="form-group col-12 mb-3">
                        <span class="badge bg-black fw-bold d-block text-start" style="white-space: break-spaces;line-height: 25px;">{{ $question->kpi_question_question }}</span>
                    </div>
                    <input type="hidden" name="questionsIDS[]" value="{{ $question->kpi_question_id }}">
                    <div class="form-group col-4 mb-3">
                        <label for="question_{{ $question->kpi_question_id }}_target">{{ __('Target') }}</label>
                        <input type="number" class="form-control target" name="question[{{ $question->kpi_question_id }}][target]" id="question_{{ $question->kpi_question_id }}_target" value="{{ $question->employee_target }}"/>
                    </div>
                    <div class="form-group col-4 mb-3">
                        <label for="question_{{ $question->kpi_question_id }}_actual">{{ __('Actual') }}</label>
                        <input type="number" class="form-control actual"  name="question[{{ $question->kpi_question_id }}][actual]" id="question_{{ $question->kpi_question_id }}_actual" value="{{  $question->employee_actual }}"/>
                    </div>
                    <div class="form-group col-4 mb-3">
                        <label for="question_{{ $question->kpi_question_id }}_score">{{ __('Score') }}</label>
                        {{--                    <input type="text" disabled class="form-control score"  name="question[{{ $question->kpi_question_id }}][score][]" id="question_{{ $question->kpi_question_id }}_score"/>--}}
                        <div class="progress " style="height: 40px;">
                            <div class="progress-bar score" role="progressbar" style="width: {{ $question->employee_score }}%" aria-valuenow="{{ $question->employee_score }}" aria-valuemin="0" aria-valuemax="100">
                                {{ $question->employee_score }}%
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    @endforeach
@endif
