<?php

namespace App\Http\Middleware;

use App\Http\Resources\MediaImageResource;
use App\Models\Language;
use App\Models\TemporaryUpload;
use Illuminate\Auth\Middleware\Authenticate as Middleware;
use Illuminate\Http\Request;
use Closure;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\View;

class UserRoles
{
    public function getRoute(){
        return Route::current()->getName();
    }
    public function handle(Request $request, Closure $next)
    {
        if(auth()->check()){
            $type=null;
            $page=null;
            if(str_contains($this->getRoute(),'.')){
                list($type,$page)=explode('.',$this->getRoute());
            }
//            dd($this->getRoute(),PerUser($this->getRoute()));
//            $session_id=session()->getId();
//            $temp=TemporaryUpload::where('session_id',$session_id)->first();
//            View::share('mediaImages',($temp)?MediaImageResource::collection($temp->getMedia('support_request')):[]);
            if(PerUser($this->getRoute())||($page=='multi_destroy'&&PerUser($type.'.destroy'))||($page=='store'&&PerUser($type.'.create'))||($page=='update'&&PerUser($type.'.edit'))||in_array($this->getRoute(),['dashboard','users.profile','users.profile_update'])){
                return $next($request);
            }
            alert()->error(__('Error'),__('You don\'t have permission for this page'));
            return redirect()->route('dashboard');
        }
    }
}
