<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use App\Models\Department;
use App\Models\JobTitle;
use App\Models\KPI;
use App\Models\KPISQuestion;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        // \App\Models\User::factory(10)->create();

        // \App\Models\User::factory()->create([
        //     'name' => 'Test User',
        //     'email' => 'test@example.com',
        // ]);
        Department::factory(100)->create();
        JobTitle::factory(100)->create();
        $this->call(UsersTableSeeder::class);
        $this->call(RolesAndPermissionsSeeder::class);
        foreach (Department::pluck('id')->toArray() as $id){
            User::factory(fake()->randomNumber(1))->create([
                'department_id'=>$id,
                'job_title_id'=>$id,
            ]);
        }
//        User::factory(30)->create();
        foreach (User::where('id','!=',1)->get() as $user){
            $user->assignRole('admin');
        }
        KPI::factory(50)->create();
        foreach (DB::select("SELECT CONCAT(\"DELETE FROM kpis WHERE job_title_id='\",job_title_id,\"';\") AS query FROM (SELECT job_title_id,COUNT('X') AS count FROM `kpis` GROUP BY job_title_id) AS dd WHERE count>1") as $d){
            DB::select($d->query);
        }
        $total=100;
        foreach (KPI::get() as $kpi){
            $num_numbers=rand(3,10);
            $numbers = [];

            $loose_pcc = $total / $num_numbers;

            for($i = 1; $i < $num_numbers; $i++) {
                // Random number +/- 10%
                $ten_pcc = $loose_pcc * 0.1;
                $rand_num = mt_rand( ($loose_pcc - $ten_pcc), ($loose_pcc + $ten_pcc) );

                $numbers[] = $rand_num;
            }

            // $numbers now contains 1 less number than it should do, sum
            // all the numbers and use the difference as final number.
            $numbers_total = array_sum($numbers);

            $numbers[] = $total - $numbers_total;
            $x=1;
            foreach ($numbers as $weight){
                KPISQuestion::factory()->create([
                    'kpi_id'=>$kpi->id,
                    'weight'=>$weight,
                    'order'=>$x,
                ]);
                $x++;
            }
        }
        foreach (User::get() as $user){
            updateModelPath($user);
        }

        $this->call(UsersKPISSeeder::class);
    }
}
