@extends('dashboard.layouts.app')
@push('headScripts')
    <link href="{{ asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet" type="text/css">
@endpush
@section('content')

    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">{{ __('Users & Roles') }} /</span> {{ __('Roles') }}</h4>
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <h5 class="card-header">{{ __('Roles') }}</h5>
                    @if(PerUser('roles.create'))
                        <div class="m-4 mb-0 mt-0">
                            @if(PerUser('roles.create'))
                                <a href="{{ route('roles.create') }}" class="btn btn-primary float-end"><i class="fadeIn animated bx bx-message-square-add"></i> {{ __('Create :type',['type'=>__('Role')]) }}</a>
                            @endif
                        </div>
                    @endif
                    <div class="card-body">
                        <div class="table-responsive">
                            {{ $dataTable->table(['class' => 'table table-bordered table-striped mb-0']) }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('footerScripts')
    <script src="{{ asset('vendor/sweetalert/sweetalert.all.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
    {{ $dataTable->scripts(attributes: ['type' => 'module']) }}
    <script>
        $(document).on('click','.delete-this',function(e){
            e.preventDefault()
            let el=$(this);
            let url=el.attr('data-url')
            let id=el.attr('data-id')
            Swal.fire({
                title: '{{ __('Do you really want to delete this?') }}',
                showCancelButton: true,
                confirmButtonText: '{{ __('Yes') }}',
                cancelButtonText: '{{ __('No') }}',
            }).then((result) => {
                /* Read more about isConfirmed, isDenied below */
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: url,
                        success: function (msg) {
                            window.LaravelDataTables["roles"].draw();
                            Swal.fire(msg.message, '', msg.success?'success':'error')
                        }
                    });

                }
            })
        })
    </script>
@endpush
