<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users_kpis', function (Blueprint $table) {
            $table->id();
            $table->integer('kpi_id')->default(0);
            $table->integer('user_id')->default(0);
            $table->integer('year')->nullable();
            $table->tinyInteger('month')->nullable();
            $table->integer('total_kpi_question_weight')->default(0);
            $table->integer('total_employee_target')->default(0);
            $table->integer('total_employee_actual')->default(0);
            $table->integer('total_employee_score')->default(0);
            $table->integer('updated_by')->default(0);
            $table->integer('created_by')->default(0);
            $table->integer('deleted_by')->default(0);
            $table->softDeletes();
            $table->timestamps();
            $table->index('id','id_index');
            $table->index('kpi_id','kpi_id_index');
            $table->index('user_id','user_id_index');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users_kpis');
    }
};
