<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        //when add any kpi for employee can't update
        Schema::create('kpis', function (Blueprint $table) {
            $table->id();
            $table->integer('job_title_id')->default(0);
            $table->string('name')->nullable();
            $table->enum('status',config('app.statusArray'))->nullable();
            $table->integer('updated_by')->default(0);
            $table->integer('created_by')->default(0);
            $table->integer('deleted_by')->default(0);
            $table->softDeletes();
            $table->timestamps();
            $table->index('id','id_index');
            $table->index('job_title_id','job_title_id_index');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('kpis');
    }
};
