<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class KPISQuestion extends Model
{
    use HasFactory,SoftDeletes;
    protected $guarded=['id'];
    protected $table='kpis_questions';
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_changes_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_changes_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_changes_action('delete',$model);
        });
    }
}
