<?php

namespace App\Http\Controllers\Dashboard;

use App\DataTables\KPISDataTable;
use App\Exports\KPISExport;
use App\Http\Controllers\Controller;
use App\Models\KPISQuestion;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;
use App\Models\KPI;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rule;
use Maatwebsite\Excel\Facades\Excel;

class KPISController extends Controller
{
    //
    //
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(KPISDataTable $dataTable){
        return $dataTable->render('dashboard.kpis.index');
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //

        return view('dashboard.kpis.create_edit');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $this->validateKPIS($request);
        if($request->weight){
            $total=0;
            foreach ($request->weight as $weight){
                $total+=$weight;
            }
            if($total!=100){
                alert()->error(__('Error'),__('Total Weight of questions must be 100%'));
                return redirect()->back()->withInput();
            }
        }
        $kpi=KPI::create(array_merge($request->only(['job_title_id','name','status']),['created_by'=>auth()->id()]));
        $x=1;
        foreach ($request->question as $key=>$question){
            $createdData=[
                'kpi_id'=>$kpi->id,
                'question'=>$question,
                'weight'=>$request->weight[$key],
                'order'=>$x,
                'created_by'=>auth()->id(),
            ];
            KPISQuestion::create($createdData);
            $x++;
        }
        alert()->success(__('Success'),__('Create Successfully'));
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(KPI $kpi)
    {
        //
        return view('dashboard.kpis.create_edit',compact('kpi'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, KPI $kpi)
    {
        //
        $this->validateKPIS($request);
        if($request->weight){
            $total=0;
            foreach ($request->weight as $weight){
                $total+=$weight;
            }
            if($total!=100){
                alert()->error(__('Error'),__('Total Weight of questions must be 100%'));
                return redirect()->back()->withInput();
            }
        }
        $updateData=array_merge($request->only('job_title_id','name','status'),['updated_by'=>auth()->id()]);
        $kpi->update($updateData);
        //dd($request->input());
        $x=1;
        $IDS=[];
        foreach ($request->question as $key=>$question){
            $createdData=[
                'kpi_id'=>$kpi->id,
                'question'=>$question,
                'weight'=>$request->weight[$key],
                'order'=>$x,
            ];
            if(isset($request->question_id[$key])){
                $KPIQuestion=KPISQuestion::find($request->question_id[$key]);
                if($KPIQuestion){
                    KPISQuestion::where('id',$request->question_id[$key])->update(array_merge($createdData,['updated_by'=>auth()->id()]));
                }else{
                    $KPIQuestion=KPISQuestion::create(array_merge($createdData,['created_by'=>auth()->id()]));
                }
            }else{
                $KPIQuestion=KPISQuestion::create(array_merge($createdData,['created_by'=>auth()->id()]));
            }
            $IDS[]=$KPIQuestion->id;
            $x++;
        }
        KPISQuestion::where('kpi_id',$kpi->id)->whereNotIn('id',$IDS)->update([
            'deleted_by'=>auth()->id(),
            'deleted_at'=>now(),
        ]);
        alert()->success(__('Success'),__('Update Successfully'));
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(KPI $kpi)
    {
        //
        $kpi->deleted_by=auth()->id();
        $kpi->save();
        $kpi->delete();
        return response()->json(['success'=>true,'message'=>__('Delete Successful')]);
    }

    public function validateKPIS($request){
        $valid=[
            'status'=>'required|in:'.implode(',',config('app.statusArray')),
        ];
        if(!$request->question){
            $valid['question.0']='required';
        }else{
            foreach ($request->question as $key=>$val){
                $valid['question.'.$key]='required';
            }
        }
        if(!$request->weight){
            $valid['weight.0']='required';
        }else{
            foreach ($request->weight as $key=>$val){
                $valid['weight.'.$key]='required';
            }
        }


        if($request->kpi){
            $valid['job_title_id']=['required',Rule::unique('kpis','job_title_id')->whereNull('deleted_at')->ignore($request->kpi->id,'id')];
//            $valid['email']='required|email|unique:kpis,email,'.$request->kpi->id.',NULL,deleted_at,NULL';
            $valid['name']=['required',Rule::unique('kpis','name')->whereNull('deleted_at')->ignore($request->kpi->id,'id')];
        }else{
           $valid['job_title_id']='required|unique:kpis';
           $valid['name']='required|unique:kpis';
        }
        return $request->validate($valid);
    }
    public function deleteMulti(Request $request){
        $count=KPI::whereIn('id',$request->IDS)->update(['deleted_by'=>auth()->id(),'deleted_at'=>now()]);
        return response()->json(['success'=>true,'message'=>__('Delete :count Successful',['count'=>$count])]);
    }
    public function export(Request $request){
        switch ($request->export_type){
            case'csv':
                return Excel::download(new KPISExport,'kpis_'.time().'.csv',\Maatwebsite\Excel\Excel::CSV);
                break;
            case'excel':
                return Excel::download(new KPISExport,'kpis_'.time().'.xlsx',\Maatwebsite\Excel\Excel::XLSX);
                break;
            case'pdf':
                $kpis=KPI::query();
                if(request('IDS')){
                    $kpis=$kpis->whereIn('id',explode(',',request('IDS')));
                }
                $kpis=$kpis->get();
                return Pdf::loadView('dashboard.kpis.export_pdf',['kpis'=>$kpis])->download('kpis_'.time().'.pdf');
                break;
        }

    }

}
