@extends('dashboard.layouts.app')
@push('headScripts')
@endpush
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">{{ __('Departments & Job Titles') }} /</span> <a href="{{ route('job_titles.index') }}" class="text-muted fw-light">{{ __('Job Titles') }} /</a> {{ (isset($job_title))?__('Edit :type',['type'=>$job_title->name]):__('Create') }}</h4>
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <h5 class="card-header">{{ (isset($job_title))?__('Edit :type',['type'=>$job_title->name]):__('Create') }}</h5>
                    <form method="POST" action="{{ isset($job_title)?route('job_titles.update',['job_title'=>$job_title]):route('job_titles.store') }}" enctype="multipart/form-data">
                        @if(isset($job_title))
                            @method('PUT')
                        @endif
                        @csrf
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-lg-12 mb-3">
                                    <label class="form-label">{{ __('Title') }}</label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror border-left-0" name="title" id="title" value="{{ isset($job_title)?$job_title->title:old('title') }}" placeholder="{{ __('Enter :value',['value'=>__('Job Title')]) }}">
                                    @error('title')
                                    <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                    @enderror

                                </div>
                                <div class="btn-group" role="group" aria-label="Basic radio toggle button group">
                                    @foreach(config('app.statusArray') as $key=>$status)
                                    <input type="radio" class="btn-check" name="status" id="status-{{ $key+1 }}" {{ (isset($job_title)&&$job_title->status==$status)||(old('status')&&old('status')==$status)||(!isset($job_title)&&!old('status')&&$status==config('app.defaultStatusSelected'))?'checked':'' }} value="{{ $status }}"  autocomplete="off">
                                        <label class="btn btn-outline-{{ config('app.statusButtonClass')[$status] }}" for="status-{{ $key+1 }}">{{ ucfirst($status) }}</label>
                                    @endforeach

                                </div>
                                @error('status')
                                <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="text-center">
                            <button type="submit" class="btn btn-danger px-5">{{ __('Save') }}</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
@endsection

@push('footerScripts')
    <script src="{{ asset('js/permissions_table.js') }}"></script>
@endpush
