@extends('dashboard.layouts.app')
@push('headScripts')
    <link href="{{ asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet" type="text/css">@endpush
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="float-end">
            <div class="row">
                <div class="form-group col-4">
                    <select name="search_by" style="width:100%" class="select2" id="search_by">
                        <option selected="selected" value="created_at">Search By Created</option>
                        <option selected="selected" value="year_month">Search By Year & Month</option>
                    </select>
                </div>
                <div class="col-8">
                    <div id="reportrange" style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc; width: 100%">
                        <i class="fa fa-calendar"></i>&nbsp;
                        <span></span> <i class="fa fa-caret-down"></i>
                        <input type="hidden" id="start_date">
                        <input type="hidden" id="end_date">
                    </div>
                </div>
            </div>
        </div>
        <h4 class="fw-bold py-3 mb-4">
            <span class="text-muted fw-light">{{ __('KPIS') }} /</span> {{ __('User KPIS') }}
        </h4>

        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <h5 class="card-header">{{ __('User KPIS') }}</h5>
                        <div class="m-4 mb-0 mt-0">
                            @if(PerUser('users_kpis.export'))
                                <div class="btn-group float-end ms-1 me-1" role="group">
                                    <button id="exportSelectedUserKPIS" type="button" class="btn btn-primary dropdown-toggle export-selected" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="fadeIn animated bx bx-export"></i>
                                        {!! __('Export Selected :type',['type'=>__('UserKPI')]) !!}
                                    </button>
                                    <div class="dropdown-menu" aria-labelledby="exportSelectedUserKPIS">
                                        <a class="dropdown-item export-type" data-type="csv">{{ __('CSV') }}</a>
                                        <a class="dropdown-item export-type" data-type="excel">{{ __('Excel') }}</a>
                                        <a class="dropdown-item export-type" data-type="pdf">{{ __('PDF') }}</a>
                                    </div>
                                    <form action="{{ route('users_kpis.export') }}" method="POST" id="exportData" class="d-inline-block">
                                        <input type="hidden" id="exportIDS" name="IDS">
                                        <input type="hidden" name="export_type" value="excel">
                                        @csrf
                                        {{--                            <button class="btn btn-info export-selected"><i class="fadeIn animated bx bx-export"></i> {!! __('Export Selected :type',['type'=>__('UserKPI')]) !!}</button>--}}
                                    </form>
                                </div>
                                <div class="btn-group float-end ms-1 me-1" role="group">
                                    <button id="exportUserKPIS" type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="fadeIn animated bx bx-export"></i>
                                        {{ __('Export') }}
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-left" aria-labelledby="exportUserKPIS">
                                        <a class="dropdown-item export-type" data-type="csv">{{ __('CSV') }}</a>
                                        <a class="dropdown-item export-type" data-type="excel">{{ __('Excel') }}</a>
                                        <a class="dropdown-item export-type" data-type="pdf">{{ __('PDF') }}</a>
                                    </div>
                                    <form action="{{ route('users_kpis.export') }}" method="POST" class="d-inline-block">
                                        <input type="hidden" name="export_type" value="excel">
                                        @csrf
                                        {{--                            <button class="btn btn-info "><i class="fadeIn animated bx bx-export"></i> {{ __('Export') }}</button>--}}
                                    </form>
                                </div>


                            @endif
                            @if(PerUser('users_kpis.destroy'))
                                <a href="#" class="btn btn-danger delete-selected float-end ms-1 me-1"><i class="fadeIn animated bx bx-trash-alt"></i> {!! __('Delete Selected :type',['type'=>__('UserKPI')]) !!}</a>
                            @endif
                            @if(PerUser('users_kpis.create'))
                                <a href="{{ route('users_kpis.create') }}" class="btn btn-primary float-end ms-1 me-1"><i class="fadeIn animated bx bx-message-square-add"></i> {{ __('Create :type',['type'=>__('UserKPI')]) }}</a>
                            @endif
                        </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            {{ $dataTable->table(['class' => 'table table-bordered table-striped mb-0']) }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('footerScripts')
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <script src="{{ asset('vendor/sweetalert/sweetalert.all.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
    {{ $dataTable->scripts(attributes: ['type' => 'module']) }}
    <script>
        var start = moment().subtract(29, 'days');
        var end = moment();

        function cb(start, end) {
            $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
            $("#start_date").val(start.format('YYYY-MM-DD'))
            $("#end_date").val(end.format('YYYY-MM-DD'))
            if(typeof window.LaravelDataTables!='undefined'){
                window.LaravelDataTables["users_kpis"].draw();
            }
        }


        $('#reportrange').daterangepicker({
            startDate: start,
            endDate: end,
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            }
        }, cb);

        cb(start, end);
        $(document).on('change','#search_by',function (){
            window.LaravelDataTables["users_kpis"].draw();
        });
        $(document).on('click','.export-type',function(e){
            e.preventDefault();
            let form=$(this).parent().parent().find('form')
            form.find('[name="export_type"]').val($(this).attr('data-type'));
            form.submit();
        })
        function checkMultiDeleteButton(){
           if($(".user_kpi-checkbox").is(':checked')){
               $(".delete-selected").removeClass('disabled');
               $(".export-selected,.export-types").removeClass('disabled');
           }else{
               $(".delete-selected").addClass('disabled')
               $(".export-selected,.export-types").addClass('disabled')

           }
        }
        checkMultiDeleteButton();
        $(document).on('click','.delete-selected',function(){
            let IDS=[];
            $('.user_kpi-checkbox:checked').each(function(){
                IDS.push($(this).val());
            })
            Swal.fire({
                title: '{{ __('Do you really want to delete this?') }}',
                showCancelButton: true,
                confirmButtonText: '{{ __('Yes') }}',
                cancelButtonText: '{{ __('No') }}',
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: "{{ route('users_kpis.multi_destroy') }}",
                        data:{IDS},
                        success: function (msg) {
                            window.LaravelDataTables["users_kpis"].draw();
                            Swal.fire(msg.message, '', msg.success?'success':'error')
                            $(".delete-selected").addClass('disabled').find('.selectedCount').text(0)
                        }
                    });

                }
            })
        })
        function addSelectedCount(){
            $(".selectedCount").text($(".user_kpi-checkbox:checked").length)
            let IDS=[];
            $('.user_kpi-checkbox:checked').each(function(){
                IDS.push($(this).val());
            })
            $("#exportIDS").val(IDS);
        }
        $(document).on('change','#selectAllCheckbox',function(){
            $('table#users_kpis tbody input[type="checkbox"].user_kpi-checkbox').prop('checked',$(this).is(':checked'))
            checkMultiDeleteButton();
            addSelectedCount()
        });
        $(document).on('change','.user_kpi-checkbox',function (){
            checkMultiDeleteButton();
            addSelectedCount()
        })
        @if(PerUser('users_kpis.destroy'))
        $(document).on('click','.delete-selected',function(){

        });
        $(document).on('click','.delete-this',function(e){
            e.preventDefault()
            let el=$(this);
            let url=el.attr('data-url')
            let id=el.attr('data-id')
            Swal.fire({
                title: '{{ __('Do you really want to delete this?') }}',
                showCancelButton: true,
                confirmButtonText: '{{ __('Yes') }}',
                cancelButtonText: '{{ __('No') }}',
            }).then((result) => {
                /* Read more about isConfirmed, isDenied below */
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: url,
                        success: function (msg) {
                            window.LaravelDataTables["users_kpis"].draw();
                            Swal.fire(msg.message, '', msg.success?'success':'error')
                        }
                    });

                }
            })
        })
        @endif
    </script>
@endpush
